(function() {
  //    FILE:EventModel
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  define(['Backbone', 'moment', 'models/request/RequestModel', 'Backbone.LocalStorage'], function(Backbone, Moment, RequestModel, LocalStorage) {
    var BookingstructuresModel;
    return BookingstructuresModel = (function() {
      class BookingstructuresModel extends Backbone.Model {
        initialize() {
          //console.log "Model BookingStructures initialized"
          return this.reqMdl = new RequestModel();
        }

        get_booking_structures(usr) {
          var empty, jsonReq, response, that, xmlReq;
          empty = true;
          that = this;
          this.fetch({
            success: function(data) {
              if (!_.isEmpty(data.attributes)) {
                empty = false;
                return that.trigger('bsChanged');
              }
            }
          });
          if (empty) {
            jsonReq = this.reqMdl.get('JGetBookingStructures');
            this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
            xmlReq = this.reqMdl.__getXML(jsonReq);
            response = this.reqMdl.__send_server_xmlrequest(xmlReq);
            response.done(function(data, textStatus, jqXHR) {
              var jsonObj, res;
              jsonObj = data;
              if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
                window.localStorage.clear();
                window.location.href = 'index.html?expired=1';
              }
              if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
                res = jsonObj.Result;
                res['id'] = '1';
                that.save(res);
                return that.trigger('bsChanged');
              }
            });
          }
          return this;
        }

      };

      BookingstructuresModel.prototype.localStorage = new LocalStorage('BookingStructures');

      return BookingstructuresModel;

    }).call(this);
  });

}).call(this);
